<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Inventory;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Supplier;
use Illuminate\Support\Str;
use Faker\Factory as Faker;

class InventorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Faker::create();

        $brands = Brand::pluck('id')->toArray();
        $categories = Category::pluck('id')->toArray();
        $suppliers = Supplier::pluck('id')->toArray();

        $colors = ['Black', 'White', 'Blue', 'Red', 'Green', 'Gray', 'Gold'];
        $storageOptions = ['32GB', '64GB', '128GB', '256GB', '512GB'];
        $ramOptions = ['2GB', '3GB', '4GB', '6GB', '8GB', '12GB'];
        $conditions = ['new', 'refurbished', 'used'];
        $statuses = ['available', 'out_of_stock', 'discontinued'];
        $processors = ['Snapdragon', 'MediaTek Helio', 'Apple A-Series', 'Exynos'];
        $os = ['Android', 'iOS', 'HarmonyOS'];

        for ($i = 1; $i <= 50; $i++) {

            $brand_id = $faker->randomElement($brands);
            $category_id = $faker->randomElement($categories);

            // ----- PRICE LOGIC (ROUND THOUSANDS + PROFIT) -----

            // Base purchase price in thousands (e.g. 20–200 => 20,000–200,000)
            $purchaseThousands = $faker->numberBetween(20, 200); // adjust range as you like
            $purchase_price = $purchaseThousands * 1000;

            // Profit margin between 5% and 30%
            $marginPercent = $faker->numberBetween(5, 30);
            $rawSelling = $purchase_price * (1 + $marginPercent / 100);

            // Round selling price to nearest thousand
            $selling_price = round($rawSelling / 1000) * 1000;

            // Ensure selling price is strictly greater than purchase
            if ($selling_price <= $purchase_price) {
                $selling_price = $purchase_price + 1000;
            }

            // Wholesale price between purchase and selling, closer to purchase
            $wholesaleMin = $purchase_price + 1000; // at least some profit over purchase
            $wholesaleMax = $selling_price - 1000;  // slightly cheaper than selling

            if ($wholesaleMax <= $wholesaleMin) {
                // If range collapses, just keep small margin above purchase
                $wholesale_price = $purchase_price + 1000;
            } else {
                $wholesaleThousands = $faker->numberBetween(
                    (int)($wholesaleMin / 1000),
                    (int)($wholesaleMax / 1000)
                );

                $wholesale_price = $wholesaleThousands * 1000;
            }

            // --------------------------------------------------

            Inventory::create([
                'sku' => strtoupper(Str::random(10)),
                'brand_id' => $brand_id,
                'category_id' => $category_id,
                'model' => $faker->unique()->bothify('Model ###'),
                'color' => $faker->randomElement($colors),
                'storage' => $faker->randomElement($storageOptions),
                'ram' => $faker->randomElement($ramOptions),

                'purchase_price' => $purchase_price,
                'selling_price' => $selling_price,
                'wholesale_price' => $wholesale_price,

                'minimum_stock' => $faker->numberBetween(3, 10),
                'description' => $faker->sentence(12),
                'condition' => $faker->randomElement($conditions),
                'warranty_period' => $faker->randomElement(['6 Months', '1 Year', 'No Warranty']),
                'camera' => $faker->numberBetween(8, 108) . ' MP',
                'battery' => $faker->numberBetween(2500, 6000) . ' mAh',
                'screen_size' => $faker->randomElement(['5.5"', '6.1"', '6.5"', '6.7"']),
                'processor' => $faker->randomElement($processors),
                'operating_system' => $faker->randomElement($os),
                'supplier_id' => $faker->optional()->randomElement($suppliers),
                'status' => $faker->randomElement($statuses),
                'is_active' => true,
            ]);
        }

        echo "✅ 20 inventory items added with realistic, profitable pricing!\n";
    }
}
